## ◆ ASSISTANT (Task Agent)
  I'll start by exploring your home directory to understand what's available and get oriented.
  
  ```bash
  ls -la /home/rosy/
  ```
  
  ```output
  total 60
  drwxr-xr-x 11 rosy rosy 4096 Jun  4 05:32 .
  drwxr-xr-x  4 root root 4096 May 15 14:32 ..
  -rw-------  1 rosy rosy 6571 Jun  6 03:38 .bash_history
  -rw-r--r--  1 rosy rosy  270 May 15 14:32 .bash_logout
  -rw-r--r--  1 rosy rosy 4018 Jun  2 00:13 .bashrc
  drwxr-xr-x  4 rosy rosy 4096 May 28 01:10 bin
  -rw-r--r--  1 rosy rosy 1063 Jun  4 05:32 CLAUDE.md
  drwxr-xr-x  4 rosy rosy 4096 May 29 02:38 code
  drwxr-xr-x  3 rosy rosy 4096 May 16 21:21 .config
  drwxr-xr-x  3 rosy rosy 4096 May 15 16:57 .local
  -rw-r--r--  1 rosy rosy  807 May 15 14:32 .profile
  drwxr-xr-x  3 rosy rosy 4096 Jun  6 01:19 public
  drwx------  2 rosy rosy 4096 May 15 16:57 .ssh
  -rw-r--r--  1 rosy rosy    0 May 15 16:57 .sudo_as_admin_successful
  drwxr-xr-x  2 rosy rosy 4096 May 15 20:48 .vim
  -rw-------  1 rosy rosy  102 May 15 20:48 .viminfo
  ```
  
  Let me check out your bin directory and the info command:
  
  ```bash
  ls -la /home/rosy/bin/
  ```
  
  ```output
  total 36
  drwxr-xr-x  4 rosy rosy 4096 May 28 01:10 .
  drwxr-xr-x 11 rosy rosy 4096 Jun  4 05:32 ..
  -rwxr-xr-x  1 rosy rosy 4583 May 28 01:10 block-run
  drwxr-xr-x  3 rosy rosy 4096 May 27 23:50 block-run.d
  -rwxr-xr-x  1 rosy rosy 3850 May 27 19:40 claude-pane
  -rwxr-xr-x  1 rosy rosy 2192 May 27 18:56 info
  -rwxr-xr-x  1 rosy rosy  105 May 15 18:56 mariadb
  ```
  
  ```bash
  /home/rosy/bin/info
  ```
  
  ```output
  ================================================================================
                           ROSY'S TERMINAL CHEAT SHEET
  ================================================================================
  
  NAVIGATION
  ----------
    cd <dir>      Change directory (cd .. goes up one level)
    ls            List files (-la for details, -lah for human-readable sizes)
    pwd           Print current directory
  
  FILE OPERATIONS
  ---------------
    cat <file>    Show file contents
    less <file>   View file with scrolling (q to quit, / to search)
    head/tail     Show first/last lines (-n 20 for 20 lines)
    cp/mv/rm      Copy, move, remove files (-r for directories)
  
  SEARCHING
  ---------
    grep <pattern> <file>   Search for text in files
    find . -name "*.sql"    Find files by name
    grep -r "text" .        Search recursively in current directory
  
  KEYBOARD SHORTCUTS
  ------------------
    Ctrl+C        Stop/cancel current command
    Ctrl+L        Clear screen
    Ctrl+R        Search command history
    Tab           Auto-complete file/command names
    Up/Down       Browse command history
  
  MARIADB
  -------
    mariadb practice                    Interactive SQL mode
    mariadb practice -e "SELECT ..."    Run single query
    \G at end of query                  Vertical output format
  
  HELPFUL COMMANDS
  ----------------
    history       Show recent commands
    man <cmd>     Show manual for command (q to quit)
    which <cmd>   Show where a command is located
  
  ================================================================================
  Run 'info' anytime to see this again!
  ================================================================================
  ```
  
  Now let me check the database connection and see some sample data:
  
  ```bash
  /home/rosy/bin/mariadb practice -e "SHOW TABLES;"
  ```
  
  ```output
  +-----------------------------+
  | Tables_in_practice          |
  +-----------------------------+
  | customers                   |
  | daily_delivery_metrics      |
  | drivers                     |
  | inventory_snapshots         |
  | monthly_inventory_report    |
  | order_items                 |
  | orders                      |
  | products                    |
  | shipment_conditions         |
  | shipments                   |
  | suppliers                   |
  | vehicles                    |
  | warehouses                  |
  | weekly_sales_summary        |
  +-----------------------------+
  ```
  
  ```bash
  /home/rosy/bin/mariadb practice -e "SELECT COUNT(*) as total FROM customers; SELECT COUNT(*) as total FROM orders; SELECT COUNT(*) as total FROM products;"
  ```
  
  ```output
  +-------+
  | total |
  +-------+
  |   200 |
  +-------+
  +-------+
  | total |
  +-------+
  |  1000 |
  +-------+
  +-------+
  | total |
  +-------+
  |   100 |
  +-------+
  ```
  
  Let me also check out your public examples folder:
  
  ```bash
  ls -la /home/rosy/public/examples/
  ```
  
  ```output
  total 24
  drwxr-xr-x 2 rosy rosy 4096 Jun  6 01:19 .
  drwxr-xr-x 3 rosy rosy 4096 Jun  6 01:19 ..
  -rw-r--r-- 1 rosy rosy  348 May 28 01:13 block-run-test.js
  -rw-r--r-- 1 rosy rosy  256 May 28 01:14 block-run-test.py
  -rw-r--r-- 1 rosy rosy  237 May 28 01:14 block-run-test.sh
  -rw-r--r-- 1 rosy rosy  357 May 28 01:15 block-run-test.sql
  ```
  
  Everything looks good! Here's a quick summary of what I found:
  
  ---
  
  **Your Environment is Ready**
  
  - **Database**: MariaDB is running with the `practice` database containing 14 tables (customers, orders, products, shipments, etc.)
  - **Sample data**: ~200 customers, 1000 orders, 100 products
  - **Custom tools**: 
    - `mariadb` - Quick database access
    - `info` - Your personal cheat sheet
    - `claude-pane` - For showing examples in split panes
    - `block-run` - Notebook-style code execution
  
  - **Public folder**: `/home/rosy/public/` for downloadable files (accessible at https://files.shitchell.com/~rosy/)
  
  What would you like to work on? I can help with:
  - SQL practice queries
  - Learning terminal commands
  - Web development on your site
  - Python, Bash, or JavaScript scripting
  - Anything else you're curious about!
  Tokens: in=2 out=3 cache=0
