## ◆ ASSISTANT (Task Agent)
  I'll start by checking the screen dimensions to understand the environment, then explore your home directory to see what we're working with.
  
  Let me get oriented first:
  
  ```bash
  tmux display-message -p 'Width: #{pane_width} Height: #{pane_height}' 2>/dev/null || echo "Not in tmux"
  ```
  
  ```bash
  ls -la /home/rosy/
  ```
  
  ```bash
  ls -la /home/rosy/bin/ 2>/dev/null | head -20
  ```
  
  ```bash
  ls -la /home/rosy/public/ 2>/dev/null
  ```
  
  ```bash
  ls -la /home/rosy/code/ 2>/dev/null
  ```
  
  Now let me check what's available in the database to understand the current state:
  
  ```bash
  /home/rosy/bin/mariadb practice -e "SHOW TABLES;"
  ```
  
  ```bash
  /home/rosy/bin/mariadb practice -e "SELECT COUNT(*) as customer_count FROM customers; SELECT COUNT(*) as order_count FROM orders; SELECT COUNT(*) as shipment_count FROM shipments;"
  ```
  
  I'm all warmed up and ready to help! I can see you have:
  
  - A MariaDB database (`practice`) with a logistics/supply chain dataset including customers, orders, shipments, warehouses, drivers, vehicles, products, and various reporting tables
  - Custom tools in `~/bin/` including `mariadb`, `sql-run`, `block-run`, `claude-pane`, and `info`
  - A public directory for sharing files at `~/public/`
  - A website repo at `~/code/git/rosy-web/`
  
  What would you like to work on today? I'm happy to help with:
  - **SQL queries and practice** - I can show examples in a side pane with real data
  - **Database concepts** - JOINs, aggregations, subqueries, window functions
  - **Web development** on your site
  - **Terminal skills** - commands, scripting, git
  - **Any other coding or learning topics**
  Tokens: in=2 out=3 cache=0
