// Track type for audio files
export interface Track {
  id: string;
  url: string;
  title: string;
  artist?: string;
  album?: string;
  artwork?: string;
  duration?: number;
  isLocal: boolean; // true if from device, false if from URL
}

// Playlist type
export interface Playlist {
  id: string;
  name: string;
  trackIds: string[];
  createdAt: number;
  updatedAt: number;
}

// Playback modes
export type RepeatMode = 'off' | 'track' | 'queue';

// Player state
export interface PlayerState {
  isPlaying: boolean;
  currentTrack: Track | null;
  queue: Track[];
  queueIndex: number;
  shuffle: boolean;
  repeatMode: RepeatMode;
  position: number;
  duration: number;
}

// Theme type
export type ThemeMode = 'light' | 'dark' | 'system';

// Settings
export interface Settings {
  themeMode: ThemeMode;
  defaultRepeatMode: RepeatMode;
}
