#!/bin/bash
# Hourly script to look up new visitor IP locations
# Run via cron: 0 * * * * /home/rosy/bin/update-visitor-ips.sh

LOG_FILE="/home/rosy/logs/ip-lookup.log"
mkdir -p "$(dirname "$LOG_FILE")"

echo "[$(date '+%Y-%m-%d %H:%M:%S')] Starting IP lookup..." >> "$LOG_FILE"

# Call the analytics API to trigger IP lookup
result=$(curl -s -X POST https://rosy.shitchell.com/analytics-api/lookup-ips \
  -H "Content-Type: application/json" \
  -d '{"password":"rosyshaun"}')

echo "[$(date '+%Y-%m-%d %H:%M:%S')] Result: $result" >> "$LOG_FILE"

# Keep log file from growing too large (keep last 1000 lines)
tail -1000 "$LOG_FILE" > "$LOG_FILE.tmp" && mv "$LOG_FILE.tmp" "$LOG_FILE"
