# Nginx Configuration for rosy.shitchell.com

server {
    access_log /var/www/rosy.shitchell.com/logs/access.log;
    error_log /var/www/rosy.shitchell.com/logs/error.log;
    server_name rosy.shitchell.com;

    # Block social media crawlers
    if ($http_user_agent ~* (facebookexternalhit|Facebot|Twitterbot|LinkedInBot|Pinterest|Slackbot|TelegramBot|WhatsApp|Discordbot)) {
        return 403;
    }

    location /.well-known/acme-challenge/ {
        root /var/www/certbot;
    }

    root /var/www/rosy.shitchell.com/srv/web;
    index index.html;

    location / {
        try_files $uri $uri/ =404;
    }

    location = / {
        try_files /index.html =404;
    }

    location /adminer/ {
        proxy_pass http://127.0.0.1:8082/;
        proxy_set_header Host $host;
        proxy_set_header X-Real-IP $remote_addr;
    }

    # Photo upload API
    location /upload-api/ {
        proxy_pass http://127.0.0.1:8083/;
        proxy_set_header Host $host;
        proxy_set_header X-Real-IP $remote_addr;
        client_max_body_size 25M;
    }

    listen [::]:443 ssl; # managed by Certbot
    listen 443 ssl; # managed by Certbot
    ssl_certificate /etc/letsencrypt/live/rosy.shitchell.com/fullchain.pem; # managed by Certbot
    ssl_certificate_key /etc/letsencrypt/live/rosy.shitchell.com/privkey.pem; # managed by Certbot
    include /etc/letsencrypt/options-ssl-nginx.conf; # managed by Certbot
    ssl_dhparam /etc/letsencrypt/ssl-dhparams.pem; # managed by Certbot

}


server {
    if ($host = rosy.shitchell.com) {
        return 301 https://$host$request_uri;
    } # managed by Certbot


    listen 80;
    listen [::]:80;
    server_name rosy.shitchell.com;
    return 404; # managed by Certbot


}