#!/bin/bash
# =============================================================
# HOW TO FIND HIDDEN AUDIO URLs ON WEBSITES
# =============================================================
# This script shows you step-by-step how to find audio files
# hidden in webpage source code.
# =============================================================

echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━"
echo "STEP 1: Fetch the webpage"
echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━"
echo ""
echo "Command: curl -sL \"https://buddhagate.org/zh/chinese-diamond-sutra-chanting/\""
echo ""
echo "This downloads the raw HTML code of the webpage."
echo "Let's see a small sample of what that looks like..."
echo ""
sleep 2

# Show just a snippet of the HTML
curl -sL "https://buddhagate.org/zh/chinese-diamond-sutra-chanting/" | head -20
echo ""
echo "... (hundreds more lines) ..."
echo ""
sleep 3

echo ""
echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━"
echo "STEP 2: Search for audio file extensions"
echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━"
echo ""
echo "We pipe (|) the HTML into grep to search for patterns."
echo ""
echo "The pattern searches for URLs ending in:"
echo "  .mp3, .wav, .ogg, .m4a, or .aac"
echo ""
sleep 2

echo "Running the search..."
echo ""
sleep 1

# Actually run the command
AUDIO_URL=$(curl -sL "https://buddhagate.org/zh/chinese-diamond-sutra-chanting/" | grep -oE '(https?:)?//[^"'\''<>]+\.(mp3|wav|ogg|m4a|aac)[^"'\''<>]*' | head -1)

echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━"
echo "🎉 FOUND IT!"
echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━"
echo ""
echo "$AUDIO_URL"
echo ""
sleep 2

echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━"
echo "STEP 3: Download with wget"
echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━"
echo ""
echo "Now that we have the URL, we can download it:"
echo ""
echo "  wget -O my-audio.mp3 \"$AUDIO_URL\""
echo ""
echo "Or just paste the URL in your browser!"
echo ""
echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━"
echo "THE FULL ONE-LINER:"
echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━"
echo ""
echo 'curl -sL "URL" | grep -oE '\''(https?:)?//[^"'\'\''<>]+\.(mp3|wav|ogg)[^"'\'\''<>]*'\'''
echo ""
echo "(Replace URL with any webpage that has audio!)"
echo ""
