# Thru My Lens - Photography Website Design Document

## Overview

**Website:** https://rosy.shitchell.com/photography/
**Purpose:** Personal photography portfolio showcasing nature and city photography
**Style:** Elegant, minimal, warm aesthetic with focus on the photos

---

## Color Palette

| Name | Hex Code | Usage |
|------|----------|-------|
| Background | `#f5f0eb` | Page background - warm cream/off-white |
| Ink | `#2c2825` | Primary text, headings |
| Ink Light | `#5a534d` | Secondary text, navigation, title |
| Ink Faint | `#8a847d` | Subtle text, placeholders |
| Accent | `#7a6348` | Links, buttons, highlights - warm brown |

### Color Philosophy
The palette uses warm, muted earth tones that complement photography without competing with it. The cream background (`#f5f0eb`) provides a gallery-like feel while being easier on the eyes than pure white.

---

## Typography

### Fonts
1. **Cormorant Garamond** (Google Fonts)
   - Used for: Site title, section titles, navigation, captions
   - Weights: 300 (light), 400 (regular), 500 (medium)
   - Style: Often italic for elegance

2. **Montserrat** (Google Fonts)
   - Used for: Body text, buttons, UI elements
   - Weights: 300 (light), 400 (regular), 500 (medium)

### Font Sizes
| Element | Size |
|---------|------|
| Site Title | `clamp(1.8rem, 5vw, 2.5rem)` |
| Section Title | `clamp(2rem, 5vw, 3rem)` |
| Navigation | `1.1rem` |
| Body Text | `1rem` (16px default) |
| Small Text | `0.9rem` |
| Footer | `0.85rem` |

---

## Layout Structure

```
+------------------------------------------+
|              HEADER                       |
|           "Thru Lens"                     |
+------------------------------------------+
|    NAV: Nature | City | About            |
+------------------------------------------+
|                                          |
|  NATURE SECTION                          |
|  +------+ +------+ +------+ +------+     |
|  | Photo| | Photo| | Photo| | Photo|     |
|  +------+ +------+ +------+ +------+     |
|  +------+ +------+ +------+              |
|  | Photo| | Photo| | Photo|              |
|  +------+ +------+ +------+              |
|  [X photos · Add more]                   |
|                                          |
+------------------------------------------+
|                                          |
|  CITY SECTION                            |
|  +------+ +------+ +------+ +------+     |
|  | Photo| | Photo| | Photo| | Photo|     |
|  +------+ +------+ +------+ +------+     |
|  [X photos · Add more]                   |
|                                          |
+------------------------------------------+
|                                          |
|  ABOUT SECTION                           |
|  "Light falls softly on quiet corners,   |
|   and I try to hold it still..."         |
|                              — Rosy      |
|                                          |
+------------------------------------------+
|              FOOTER                       |
|    © 2025 Rosy · Upload Photos           |
+------------------------------------------+
```

### Responsive Grid
- **Photo Grid:** `repeat(auto-fill, minmax(280px, 1fr))`
- **Gap:** 20px (25px in reorder mode)
- **Max Width:** 1400px (centered)
- **Padding:** 60px vertical, 30px horizontal (40px/20px on mobile)

---

## Components

### 1. Photo Frame
```
+---------------------------+
|  [···] <- menu button     |
|                           |
|                           |
|        PHOTO              |
|                           |
|                           |
|  ▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓▓  |
|  Photo Title (on hover)   |
+---------------------------+
```

**Specifications:**
- Aspect ratio: 1:1 (square)
- Border radius: 8px
- Box shadow: `0 4px 15px rgba(0,0,0,0.1)`
- Hover effect: translateY(-5px), shadow increases
- Image: `object-fit: cover` with scale(1.05) on hover

### 2. Action Menu (⋯)
Dropdown menu appears on photo hover:

```
+------------------+
| ✎ Edit Title    |
| ↻ Replace       |
| ↕ Rearrange     |
|------------------|
| ✕ Delete        | (red)
+------------------+
```

**Specifications:**
- Toggle button: 36px circle, white background
- Dropdown: white, 8px border-radius, shadow
- Menu items: 12px/15px padding, hover background
- Delete item: red text (`#c0392b`)

### 3. Navigation Bar
- Sticky positioning (`top: 0`)
- Backdrop blur effect (`blur(12px)`)
- Semi-transparent background
- Border top/bottom: `1px solid rgba(0,0,0,0.08)`

### 4. Lightbox
Full-screen photo viewer:
- Dark overlay: `rgba(20, 18, 16, 0.95)`
- Navigation arrows on sides
- Caption below image
- Close button (×) top-right
- Keyboard support: Arrow keys, Escape

### 5. Modals
Used for: Edit Title, Replace Photo, Delete, Rearrange Password

```
+--------------------------------+
|  Modal Title                   |
|                                |
|  [Form fields]                 |
|                                |
|  [Cancel]  [Primary Action]    |
+--------------------------------+
```

**Specifications:**
- Background overlay: `rgba(0,0,0,0.8)`
- Content: cream background, 30px padding, 12px border-radius
- Max width: 400px
- Buttons: 10px padding, 6px border-radius

---

## Interactive Features

### 1. Drag & Drop Reorder
- Enter mode via menu → "Rearrange" → password
- Photos become draggable
- Visual feedback:
  - Dragging photo: 50% opacity, scale(0.95)
  - Drop target: scale(1.02), accent border
- Floating banner at bottom: "Save Order" / "Cancel"

### 2. Photo Replace
- Shows old photo → new photo preview
- File input with drag-drop styling
- Preserves original title/metadata

### 3. Hover Effects
| Element | Effect |
|---------|--------|
| Photo frame | Lift up 5px, shadow increases |
| Photo image | Scale 1.05 |
| Photo caption | Fade in from bottom |
| Menu button | Scale 1.1 |
| Nav links | Color change to accent |

---

## File Structure

```
/var/www/rosy.shitchell.com/srv/
├── web/
│   └── photography/
│       ├── index.html          # Main gallery page
│       ├── upload.html         # Upload interface
│       └── uploads/
│           ├── landscapes/     # Nature photos
│           └── historic/       # City photos
└── upload-api/
    ├── server.js               # Node.js API server
    ├── Dockerfile
    └── docker-compose.yml
```

---

## API Endpoints

| Method | Endpoint | Purpose |
|--------|----------|---------|
| GET | `/upload-api/photos` | List all photos with metadata |
| POST | `/upload-api/upload` | Upload new photo |
| POST | `/upload-api/edit` | Edit photo title |
| POST | `/upload-api/replace` | Replace photo with new image |
| POST | `/upload-api/delete` | Delete photo |
| POST | `/upload-api/reorder` | Save new photo order |

All POST endpoints require password authentication.

---

## Responsive Breakpoints

### Mobile (max-width: 768px)
- Header padding reduced
- Navigation gap: 25px (from 40px)
- Section padding: 40px 20px
- Photo grid: `minmax(200px, 1fr)`
- Grid gap: 15px

---

## CSS Variables

```css
:root {
    --bg: #f5f0eb;
    --ink: #2c2825;
    --ink-light: #5a534d;
    --ink-faint: #8a847d;
    --accent: #7a6348;
}
```

---

## Animation Timings

| Element | Property | Duration |
|---------|----------|----------|
| Photo frame | transform, box-shadow | 0.3s |
| Photo image | transform | 0.5s |
| Caption fade | opacity | 0.3s |
| Menu dropdown | opacity, transform | 0.2s |
| Nav links | color | 0.3s |

---

## Accessibility Notes

- All images have alt text (photo title)
- Keyboard navigation for lightbox (arrows, escape)
- Focus states on interactive elements
- Sufficient color contrast for text
- `loading="lazy"` on images for performance

---

## Future Enhancement Ideas

1. **Categories** - Add more gallery sections
2. **Search/Filter** - Filter photos by title or date
3. **EXIF Data** - Display camera settings
4. **Social Sharing** - Share buttons for individual photos
5. **Comments** - Allow visitor comments
6. **Dark Mode** - Toggle between light/dark themes
7. **Slideshow** - Auto-advancing lightbox mode
8. **Download** - Allow high-res downloads

---

*Document created: December 2024*
*Website: https://rosy.shitchell.com/photography/*
